#include "setupdlg.h"
#include "ui_setupdlg.h"
#include "mainwindow.h"
#include "audioinputdlg.h"
#include "videoinputdlg.h"
#include "videoqualitydlg.h"

setupdlg::setupdlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::setupdlg)
{
    ui->setupUi(this);

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->BmpPath->setText( SC540dlg->path + QString("/Snapshot_BMP.bmp"));

    ui->JpgPath->setText( SC540dlg->path + QString("/Snapshot_JPG.jpg"));

    ui->RecordPath11->setText( SC540dlg->path + QString("/record_1.mp4"));

    ui->RecordPath12->setText( SC540dlg->path + QString("/record_2.mp4"));

    ui->RecordPath13->setText( SC540dlg->path + QString("/record_3.mp4"));

    ui->checkBox_AVI_11->setChecked(false);

    ui->checkBox_AVI_12->setChecked(false);

    ui->checkBox_AVI_13->setChecked(false);

    ui->checkBox_MP4_11->setChecked(true);

    ui->checkBox_MP4_12->setChecked(true);

    ui->checkBox_MP4_13->setChecked(true);

    ui->GPUSupport11->setChecked(false);

    ui->GPUSupport12->setChecked(false);

    ui->GPUSupport13->setChecked(false);

    ui->pushBTN_StopRecord11->setEnabled(false);

    ui->pushBTN_StopRecord12->setEnabled(false);

    ui->pushBTN_StopRecord13->setEnabled(false);

    m_nTimerId = startTimer(1000);

    ui->GPUSupport11->setDisabled(true);

    ui->pushBTN_VideoQuality->setDisabled(true);

    ui->pushBTN_SnapshotBMP->setDisabled(true);

    ui->pushBTN_SnapshotJPG->setDisabled(true);

}

setupdlg::~setupdlg()
{
    delete ui;
}

void setupdlg::closeEvent ( QCloseEvent * e )
{
    emit SetUpDialogSignal_DestroyAP();
}

void setupdlg::timerEvent( QTimerEvent *event )
{
    if( event->timerId() == m_nTimerId )
    {
        MainWindow* SC540dlg = (MainWindow*)parentWidget();

        ui->m_info->setText(SC540dlg->str_info);
    }
}

void setupdlg::on_pushBTN_VideoInput_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    VideoInputDlg video_input(SC540dlg);

    video_input.exec();
}

void setupdlg::on_pushBTN_AudioInput_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    AudioInputDlg audio_input(SC540dlg);

    audio_input.exec();
}

void setupdlg::on_pushBTN_VideoQuality_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    VideoQualityDlg video_quality(SC540dlg);

    video_quality.exec();
}

void setupdlg::on_pushBTN_SnapshotBMP_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QString bmp_path = SC540dlg->path + QString("/Snapshot_BMP.bmp");

    QByteArray bmp_path_ByteArray = bmp_path.toLocal8Bit();

    CHAR* psz = bmp_path_ByteArray.data();

    //QCAP_SNAPSHOT_BMP( m_hVideoDevice, psz );
}

void setupdlg::on_pushBTN_SnapshotJPG_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QString jpg_path = SC540dlg->path + QString("/Snapshot_JPG.jpg");

    QByteArray jpg_path_ByteArray = jpg_path.toLocal8Bit();

    CHAR* psz = jpg_path_ByteArray.data();

    //QCAP_SNAPSHOT_JPG( m_hVideoDevice, psz, 100 );
}

void setupdlg::on_pushBTN_StartRecord11_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if( ui->GPUSupport11->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    } else {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    if( ui->checkBox_MP4_11->isChecked())
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice, 0, ui->RecordPath11->text().toLatin1().data());

    ui->pushBTN_StartRecord11->setEnabled(false);

    ui->pushBTN_StopRecord11->setEnabled(true);
}

void setupdlg::on_pushBTN_StopRecord11_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice, 0 );

    ui->pushBTN_StartRecord11->setEnabled(true);

    ui->pushBTN_StopRecord11->setEnabled(false);
}

void setupdlg::on_pushBTN_StartRecord12_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if( ui->GPUSupport12->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

    } else {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }

    if( ui->checkBox_MP4_12->isChecked())
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice, 1, ui->RecordPath12->text().toLatin1().data());

    ui->pushBTN_StartRecord12->setEnabled(false);

    ui->pushBTN_StopRecord12->setEnabled(true);
}

void setupdlg::on_pushBTN_StopRecord12_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice, 1 );

    ui->pushBTN_StartRecord12->setEnabled(true);

    ui->pushBTN_StopRecord12->setEnabled(false);
}

void setupdlg::on_pushBTN_StartRecord13_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if( ui->GPUSupport13->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 2, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 2 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_4 );

    } else {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 2 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_4 );
    }

    if( ui->checkBox_MP4_13->isChecked())
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice, 2, ui->RecordPath13->text().toLatin1().data());

    ui->pushBTN_StartRecord13->setEnabled(false);

    ui->pushBTN_StopRecord13->setEnabled(true);
}

void setupdlg::on_pushBTN_StopRecord13_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice, 2 );

    ui->pushBTN_StartRecord13->setEnabled(true);

    ui->pushBTN_StopRecord13->setEnabled(false);
}

void setupdlg::on_checkBox_AVI_11_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();
    ui->RecordPath11->setText( SC540dlg->path + QString("/record_1.avi"));
    ui->checkBox_AVI_11->setChecked(true);
    ui->checkBox_MP4_11->setChecked(false);
}

void setupdlg::on_checkBox_MP4_11_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();
    ui->RecordPath11->setText( SC540dlg->path + QString("/record_1.mp4"));
    ui->checkBox_AVI_11->setChecked(false);
    ui->checkBox_MP4_11->setChecked(true);
}

void setupdlg::on_checkBox_AVI_12_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();
    ui->RecordPath12->setText( SC540dlg->path + QString("/record_2.avi"));
    ui->checkBox_AVI_12->setChecked(true);
    ui->checkBox_MP4_12->setChecked(false);
}

void setupdlg::on_checkBox_MP4_12_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();
    ui->RecordPath12->setText( SC540dlg->path + QString("/record_2.mp4"));
    ui->checkBox_AVI_12->setChecked(false);
    ui->checkBox_MP4_12->setChecked(true);
}

void setupdlg::on_checkBox_AVI_13_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();
    ui->RecordPath13->setText( SC540dlg->path + QString("/record_3.avi"));
    ui->checkBox_AVI_13->setChecked(true);
    ui->checkBox_MP4_13->setChecked(false);
}

void setupdlg::on_checkBox_MP4_13_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();
    ui->RecordPath13->setText( SC540dlg->path + QString("/record_3.mp4"));
    ui->checkBox_AVI_13->setChecked(false);
    ui->checkBox_MP4_13->setChecked(true);
}
